#Importation de la librairie sampling et du jeu de donnes
library(sampling)
data(belgianmunicipalities)
str(belgianmunicipalities)
attach(belgianmunicipalities)
head(belgianmunicipalities)

#========================================PARTIE 1========================================

#On dfinit le jeu de donnes dans 'U'
U <- belgianmunicipalities$Commune

#===============QUESTION 1===============
#On calcul le nombre total de communes dans 'Ncom'
Ncom <- nrow(belgianmunicipalities)

#===============QUESTION 2===============
#On calcul le nombre d'habitants en Belgique en 2004 dans 'Nhab'
Nhab <- sum(belgianmunicipalities$Tot04)

#===============QUESTION 3===============
#On commence une estimation avec n = 50 communes
n <- 50
e <- sample(U, n)

#On cre un dataframe avec les communes tirs alatoirement de l'chantillon et le nombre d'habitants de ces communes 
tableSample <- data.frame("Commune" = e,
                          "Nombre_habitants" = belgianmunicipalities[belgianmunicipalities$Commune %in% e,"Tot04"])

#On calcul le nombre d'habitants moyen de l'chantillon tirs
mean(tableSample$Nombre_habitants)

#On visualise le dataframe 'tableSample'
View(tableSample)

#On calcul un estimateur Nest  partir de l'chantillon e
Nest <- mean(tableSample$Nombre_habitants) * Ncom

#On calcul la diffrence entre le nombre d'habitants exact et l'estimation (Nhab - Nest)
diff <- Nhab - Nest

#Cette diffrence est due au mode de tirage. En effet, on effectue un tirage sans remise ce qui 
#explique cette faible diffrence entre les habitants et l'estimation.

#On construit un intervalle de confiance au niveau 95% (alpha = 0.05)
#x contenant le nombre d'habitants des communes tires
alpha <- 0.05
x <- tableSample$Nombre_habitants

#En utilisant la formule, on calcul les diffrentes bornes et ont les affiches
binf <- mean(x) - qnorm(1-alpha/2,n-1)*sd(x)/sqrt(n)
bsup <- mean(x) + qnorm(1-alpha/2,n-1)*sd(x)/sqrt(n)
idc <- c(binf, bsup)
idc

#Cette intervalle de confiance ne contient pas la vraie valeur Nhab. 
#On remarque d'ailleurs que l'intervalle est assez large et donc pas trs prcis.

#========================================PARTIE 2========================================
#On stocke les salaires moyens dans X
X <- belgianmunicipalities$averageincome

#===============QUESTION 1===============
#Cration du dataframe 'y' contenant toutes les communes et leurs salaires moyen
#On inclus le salaire moyen temporairement pour aider  la construction du dataframe
y <- data.frame("Commune" = belgianmunicipalities$Commune,
                "Salaire_moyen" = belgianmunicipalities$averageincome,
                "Y" = 0)

#On regarde les salaires dans le dataframe y. Les salaires >= 23500??? prennent la valeur 1
y$Y[y$Salaire_moyen >= 23500] <- 1

#On supprime la colonne qui affiche les salaires car on en a plus besoin. 
#(Elle nous a aid uniquement pour la ligne ci-dessus)
y$Salaire_moyen <- NULL

#On calcul la proportion relle dans la population
p <- round(sum(y$Y == 1) / nrow(y),2)
p

#===============QUESTION 2===============
#On prend un chantillon w de 50 communes
w <- 50
e2 <- sample(U, w)

#On cre le dataframe 'yw' qui contient les communes de l'chantillon et Y
yw <- data.frame("Commune" = e2,
                 "Y" = y[y$Commune %in% e2,"Y"])

#===============QUESTION 3===============
#On construit un intervalle de confiance p au niveau 95% (alpha = 0.05)
alpha <- 0.05

#On calcul la frquence
fn <- sum(yw$Y == 1) / nrow(yw)

#En utilisant la formule, on calcul les diffrentes bornes et ont les affiches
binf <- fn - qnorm(1-alpha/2)*sqrt((fn*(1-fn))/w)
bsup <- fn + qnorm(1-alpha/2)*sqrt((fn*(1-fn))/w)
idc <- c(binf, bsup)
idc

#Cette intervalle contient bien la valeur p qui est de 66%
#Cependant, on remarque que l'intervalle est assez large et donc pas trs prcis

#===============QUESTION 4===============
#On prend 100 chantillons de n = 50 qui sont prlevs dans la population U
n <- 50
E <- replicate(100, sample(y$Y, n))

#On affiche head(E)
head(E)

#Fonction apply pour calculer les moyennes fn des 100 chantillons
fn <- apply(E, MARGIN=2, mean)
fn

#On construit les intervalles de confiance de niveau 95% pour les fn
binf <- fn - qnorm(1-alpha/2)*sqrt(fn*(1-fn)/n)
bsup <- fn + qnorm(1-alpha/2)*sqrt(fn*(1-fn)/n)

#On cre un vecteur avec fn et les bornes (inf, sup) des idc
idc <- cbind(fn,binf, bsup)
idc

#On garde les intervalles dans un dataframe et on tablie un compteur (Si p est entre les 2 bornes, alors on met 1 au compteur)
tableIdc <- data.frame(idc)
tableIdc$compteur <- 0
tableIdc[p >= tableIdc$binf & p <= tableIdc$bsup,"compteur"] <- 1

#On affiche le nombre de 1 du compteur dans le dataframe'tableIdc'
table(tableIdc$compteur == 1)

#===============QUESTION 5===============
#On initialise B qui permettra de pouvoir compter les 100 idc  crer sur le graphique
B <- nrow(tableIdc)

#On crer le graphique plot avec diffrents paramtres
plot(tableIdc$fn, 1:B, xlim=c(0.4, 0.9), xlab="Taille d'chantillon n=100", ylab="Les diffrents chantillons", main="Intervalle de confiance pour 100 chantillons")

#On cre une boucle pour 'dessiner' tous les segments des intervalles de confiance sur le graphique
for (i in 1:B){
  segments(tableIdc$binf[i], i, tableIdc$bsup[i], i)
}

#On dessine un segment rouge sur le graphique qui reprsente p
segments(p, 1, p, B, col="red")

